NEW_INSENT_TOKEN = "<t>"
ORD_A = 97

TEMPLATE_FINANCE_Event={
    "质押": '债务人或第三方将其动产或权利移交债权人占有，将该动产或权利作为债权的担保。债务人或第三方为出质人，债权人为质权人，移交的动产或权利为质押物。动产质押物包含出质人合法占有的一切动产，权利质押物包含汇票、支票、本票、债权、存款单、仓单、提单、股份、股票、商标专用权、专利权、著作权等。质押有区别于抵押、质权。',
    "股份股权转让": '公司股东依法将自己的股东权益有偿转让给他人，股东（转让方）让他人（受让方）双方当事人意思表示一致而发生的股份股权转移，转让形式包含持份转让、股份转让、书面股权转让、非书面股权转让、即时股权转让、预约股权转让、公司参与的股权转让、公司非参与的股权转让、有偿股权转让、无偿股权转让等。如发生A公司收购B公司，在此事件类型中，A为受转让公司，B为标的物公司。',
    "投资": '投资，指国家或企业以及个人，为了特定目的，与对方签订协议，促进社会发展，实现互惠互利，输送资金的过程。又是特定经济主体为了在未来可预见的时期内获得收益或是资金增值，在一定时期内向一定领域投放足够数额的资金或实物的货币等价物的经济行为。可分为实物投资、资本投资和证券投资等。前者是以货币投入企业，通过生产经营活动取得一定利润，后者是以货币购买企业发行的股票和公司债券，间接参与企业的利润分配。',
    "减持": '高管减持是指上市公司的高管在二级市场（二级市场：指在证券发行后各种证券在不同的投资者之间买卖流通所形成的市场）卖出自己公司股票的行为。创业板高管减持的方式主要有在职抛售和辞职套现两种方式。《公司法》对高管减持进行了限制，要求上市公司高管在股票上市交易之日起一年内不得转让其所持本公司的股份，且任职期内每年转让的股份不得超过持有股份总数的25％，并在辞职半年内不得转让其所持股份。在解禁期满后，如果公司没有对股票出售的特殊限制，按照《公司法》的规定，高管每年减持的股票数量不得超过持有总量的25％。',
    "起诉": '起诉是依法向法院提出诉讼，请求法院对特定案件进行审判的行为。刑事案件的起诉，在于请求法院通过审判对被告人定罪判刑；刑事附带民事诉讼的提起，在于请求法院通过审判追究被告人的经济赔偿责任。起诉必须是发起诉讼权的公民或法人依法向有管辖权的法院进行。在中国，刑事案件的起诉，主要是指人民检察院提起公诉，只有对告诉才处理和其他不重要进行侦查的轻微刑事案件，才由被害人或其法定代理人提起自诉；刑事附带民事诉讼的提起，可以是被害人及其法定代理人，也可以是人民检察院和受侵害的法人单位。',
    "收购": '收购是指一个公司通过产权交易取得其他公司一定程度的控制权，以实现一定经济目标的经济行为。收购有区别于回购。',
    "判决": '司法机关对审理结束的案件作出裁决。',
    "签署合同": '指合作双方经过商定后在文件、条约、凭证等书面文件上签字或盖章等形式确立合作关系。',
    "担保": '当事人根据法律规定或双方约定，为促使债务人履行债务，向债权人订立担保合同。担保方式有保证、抵押、质押、留置、定金。',
    "中标": '招标人向经过评选的投标人发出中标通知书，并在规定时间内与之订立书面合同。'
}

TEMPLATE_FINANCE_Role_Name={
    "质押": ["sub-org",  "sub-per", "obj-org", "obj-per", "collateral", "date", "money", "number", "proportion"],
    "股份股权转让": ["sub-org", "sub-per", "obj-org", "obj-per", "collateral", "date", "money", "number", "proportion", "target-company"],
    "投资": ["sub", "obj", "money", "date"],
    "减持": ["sub", "obj", "title", "date", "share-per", "share-org"],
    "起诉": ["sub-org", "sub-per", "obj-org", "obj-per", "date"],
    "收购": ["sub-org", "sub-per", "obj-org", "way", "date", "money", "number", "proportion"],
    "判决": ["institution", "sub-org", "sub-per", "obj-org", "obj-per", "date", "money"],
    "签署合同": ["sub-org", "sub-per", "obj-org", "obj-per", "date", "amount"],
    "担保": ["date", "amount", "obj-org", "sub-per", "sub-org", "way"],
    "中标": ["sub", "obj", "amount", "date"]
}

TEMPLATE_FINANCE_Demo={
    "质押": ['[给定句子:“高德红外发布公告,实际控制人黄立于2019年11月5日将1100万股进行<t>质押<t>,质押方为申万宏源证券有限公司,质押股数占其所持股份比例的4.12%,占公司总股本的1.17%。“时 \n 你需要输出：{“sub-org”:“高德红外”,“sub-per”:“黄立”,“obj-org”:“申万宏源证券有限公司”,"obj-per":None,“collateral”:“股份”,"date":"2019年11月5日","number":"1100万","proportion":"1.17%"}]'],
    "股份股权转让": ['[给定句子:”根据2019年10月12日发布的最新相关公告内容,康旗股份实际控制人费铮翔拟减持上市公司股份,以协议转让方式向南平盈捷企业管理合伙企业(有限合伙)(下称“南平盈捷”)<t>转让<t>其持有的上市公司股份3976万股,占上市公司总股本的5.87%,占剔除回购专用账户中的股份后上市公司总股本的6%,上市公司股份按照每股5.38元作价,股份转让价款的总额为2.14亿元。“ \n 你需要输出：{“sub-org”:None,“sub-per”:“费铮翔”,“obj-org”:“南平盈捷企业管理合伙企业(有限合伙)、南平盈捷”,“obj-per”:None,“collateral”:“股份”,"date":"2019年10月12日","money":"2.14亿元","number":"3976万","proportion":"5.87%","target-company":"康旗股份"}]'],
    "投资": ['[给定句子:”2016年勤上股份基于半导体照明产业企业众多,竞争激烈、产能过剩和价格战普遍的情况,通过发行股份和支付现金的方式出资20亿元,高溢价<t>收购<t>广州龙文教育100%股权。” \n 你需要输出：{“sub”:“勤上股份”,“obj”:“龙文教育”,“money”:“20亿元”,“date”:“2016年”}]'],
    "减持": ['[给定句子:”12月4日晚,华谊嘉信发布公告称,南京市中级人民法院定于12月19日10时至12月20日10时止(延时除外)在淘宝网司法拍卖网络平台上公开拍卖公司控股股东刘伟所持有的公司3476万股股份,该股份数占刘伟目前持股数的21.44%,占公司总股本的5.12%,且全部处于质押、司法冻结状态。“ \n 你需要输出：{"sub":"刘伟",“obj”:“华谊嘉信”,"title":"股东","date":"12月19日10时至12月20日10时","share-per":"21.44%",“share-org”:“5.12%”}]'],
    "起诉": ['[给定句子:”事情可没消停,又过了一个月,*ST中捷7月16日的一份公告中显示,宁波沅熙联合蔡开坚又把*ST中捷<t>告上法庭<t>,要求撤销2019年5月17日被告*ST中捷于2018年度股东大会上通过的全部决议,这其中就包括上述提及的《委托协议》。” \n 你需要输出：{“sub-per”:“蔡开坚”,"sub-org":"宁波沅熙",“obj-org”:“ST中捷”,“obj-per”:None,"date":"7月16日"}]'],
    "收购": ['[给定句子:”2014年,中南重工宣布计划发行股份收购资产,计划以10亿元的价格<t>购买<t>大唐辉煌传媒股份有限公司100%的股权,交易对象有王辉、中植资本管理有限公司、北京嘉诚资本投资管理有限公司等机构,中南重工也变成了“中南文化”。“ \n 你需要输出：{“sub-org”:“中南重工、中植资本管理有限公司、北京嘉诚资本投资管理有限公司”,"sub-per":"王辉","obj-org":"大唐辉煌传媒股份有限公司",“way”:“发行股份收购资产”,"date":"2014年","money":"10亿元","number":None,"proportion":"100%"}]'],
    "判决": ['[给定句子:”9月4日晚间,康得新公告,江苏省苏州市中级人民法院<t>判决<t>公司向张家港行归还借款本金1.98亿元,并支付张家港行相应的罚息及复利,康得新、钟玉对公司债务承担连带清偿责任。” \n 你需要输出：{“institution”:“江苏省苏州市中级人民法院”,"sub-org":"张家港行","sub-per":None,“obj-org”:“康得新”,"obj-per":"钟玉","date":"9月4日","money":"1.98亿"}]'],
    "签署合同": ['[给定句子:”久其软件12月20日晚间发布公告,公司实际控制人董泰湘将其持有的公司3600万股(占公司总股本的5.0617%)股份转让给海通资管,转让总价为人民币2.42亿元,转让价格6.72元/股,12月19日(合同<t>签署<t>日)该股收盘价为7.30元,与收盘价简单估算,折价约8%。“ \n 你需要输出：{"sub-org":"久其软件","sub-per":"董泰湘",“obj-org”:“海通资管”,"obj-per":None,“date”:“12月19日”,"amount":"2.42亿元"}]'],
    "担保": ['[给定句子:”2018年4月4日,盈通实业同时作为保证人和出质人,麦鹤远、张聪、麦鹤瀛、罗彩祺、麦礼添、谭群段、麦醒中作为保证人,为帝通新材向广东顺德农村商业银行股份有限公司杏坛支行(以上简称“顺德农商行杏坛支行”)申请借款展期提供<t>担保<t>,涉及借款展期金额为338万元。” \n 你需要输出：{"obj-org":"帝通新材",“amount”:“338万元”,“way”:“保证、出质”,"sub-org":"盈通实业","sub-per":"麦鹤远、张聪、麦鹤瀛、罗彩祺、麦礼添、谭群段、麦醒中","date":"2018年4月4日"}]'],
    "中标": ['[给定句子:”龙马环卫:中标8.85亿元环卫一体化项目龙马环卫(603686)7月25日晚间公告,公司<t>中标<t>三亚市崖州区环卫一体化项目,服务期限9年,合同年化金额9829.91万元/年,合同总金额8.85亿元。“ \n 你需要输出：{"sub":"龙马环卫",“obj”:“三亚市崖州区”,"amount":"8.85亿元",“date”:“7月25日”}]']
}

TEMPLATE_FINANCE_Role={
    "质押": {
        "sub-org": '质押公司：发起质押的公司',
        "sub-per": '质押人：发起质押的个人',
        "obj-org": '质权公司：接受质押的公司',
        "obj-per": '质权人：接受质押的个人',
        "collateral": '质押物（标的，可为公司股票、大额存单等等）',
        "date": '质押日期（显示表达的日期，如“2019年9月24日”）',
        "money": '质押金额',
        "number": '质押数量',
        "proportion": '质押比例',
    },
    "股份股权转让": {
        "sub-org": '股份股权转让公司：发起股份股权转让的公司',
        "sub-per": '股份股权转让人：发起股份股权转让的个人',
        "obj-org": '受转让公司：接受股份股权转让的公司',
        "obj-per": '受转让人：接受股份股权转让的个人',
        "collateral": '股份股权转让物（标的，可为公司股票、股权等等）',
        "date": '转让日期（显示表达的日期，如“2019年9月24日”）',
        "money": '转让交易金额',
        "number": '转让数量',
        "proportion": '转让比例',
        'Target company': '标的公司：指收购行为中的收购对象公司'
    },
    "起诉": {
        "sub-org": '原告（公司）',
        "sub-per": '原告（个人）',
        "obj-org": '被告（公司）',
        "obj-per": '被告（个人）',
        "date": '起诉日期',
    },
    "投资": {
        "sub": '发起投资的组织或单位（投资方）',
        "obj": '被投资的组织或单位（被投资方）',
        "money": '投资金额',
        "date": '日期'
    },
    "减持": {
        "sub": '减持方（通常为人，少数情况为组织）',
        "obj": '被减持方',
        "title": '减持方的职务',
        "date": '日期',
        'share-per': '减持的股份占个人股份百分比',
        'share-org': '减持的股份占公司股份的百分比'
    },
    "收购": {
        "sub-org": '收购公司：发起收购的公司',
        "sub-per": '收购方：发起收购的个人',
        "obj-org": '被收购公司：接受收购的公司',
        "way": '收购方式（现金收购、股份股权收购、承担债务式收购等等）',
        "date": '收购日期（显示表达的日期，如“2019年9月24日”）',
        "money": '收购金额',
        "number": '收购股份数量',
        "proportion": '收购股份比例'
    },
    "担保": {
        "sub-org": '担保公司：发起担保的公司',
        "sub-per": '担保人：发起担保的个人',
        "obj-org": '受担保公司：接受担保的公司',
        "way": '担保方式（保证、抵押、质押、留置、定金等等）',
        "amount": '担保金额',
        "date": '担保日期（显示表达的日期，如“2019年9月24日”）'
    },
    "中标": {
        "sub": '中标方（公司）',
        "obj": '招标方（单位或组织）',
        "amount": '中标金额',
        "date": '中标日期'
    },
    "签署合同": {
        "sub-org": '发起合同签署的组织或单位（甲方）',
        "sub-per": '发起合同签署的自然人（甲方）',
        "obj-org": '接受合同签署的组织或单位（乙方）',
        "obj-per": '接受合同签署的自然人（乙方）',
        "date": '日期',
        "amount": '成交额',
    },
    "判决": {
        'institution': '裁判单位（法院）',
        "sub-org": '原告（公司）',
        "sub-per": '原告（个人）',
        "obj-org": '被告（公司）',
        "obj-per": '被告（个人）',
        "date": '判决日期',
        "money": '判决金额',
    },
}
TEMPLATE_WikiEvents_Event = {
    'ArtifactExistence.DamageDestroyDisableDismantle.Damage':"Damager damaged artifact using instrument in place",
    'ArtifactExistence.DamageDestroyDisableDismantle.Destroy':'Destroyer destroyed artifact using instrument in place',
    'ArtifactExistence.DamageDestroyDisableDismantle.DisableDefuse':'Disabler disabled or defused artifact using instrument in place',
    'ArtifactExistence.DamageDestroyDisableDismantle.Dismantle':'Dismantler dismantled artifact using instrument in place',
    'ArtifactExistence.DamageDestroyDisableDismantle.Unspecified':'Damagerdestroyer damaged or destroyed artifact using instrument in place',
    'ArtifactExistence.ManufactureAssemble.Unspecified':'Manufacturer or assembler manufactured or assembled or produced artifact from components using instrument at place',
    'Cognitive.IdentifyCategorize.Unspecified':'Identifier identified object as identifiedRole at place',
    'Cognitive.Inspection.SensoryObserve':'Observer observed entity using instrument in place',
    'Cognitive.Research.Unspecified':'Researcher researched subject using means at place',
    'Cognitive.TeachingTrainingLearning.Unspecified':'TeacherTrainer taught field of knowledge to learner using Means at institution in place',
    'Conflict.Attack.DetonateExplode':'Attacker detonated or exploded explosive device using instrument to attack target at place',
    'Conflict.Attack.Unspecified':'Attacker attacked target using instrument at place',
    'Conflict.Defeat.Unspecified':'Victor defeated defeated in conflict Or election at place',
    'Conflict.Demonstrate.DemonstrateWithViolence':'Demonstrator was in a demonstration involving violence for topic with visual display against target at place, with potential involvement of regulator police or military',
    'Conflict.Demonstrate.Unspecified':'Demonstrator was in a demonstration for topic with visual display against target at place, with potential involvement of regulator police or military',
    'Contact.Contact.Broadcast':'Communicator communicated to recipient about topic using instrument at place (one-way communication)',
    'Contact.Contact.Correspondence':'Participant communicated remotely with participant about topic using instrument at place',
    'Contact.Contact.Meet':'Participant met face-to-face with participant about topic at place',
    'Contact.Contact.Unspecified':'Participant communicated with participant about topic at place (document does not specify in person or not, or one-way or not)',
    'Contact.Prevarication.Unspecified':'Communicator communicated with recipient about topic at place (document does not specify in person or not, or one-way or not)',
    'Contact.RequestCommand.Unspecified':'Communicator communicated with recipient about topic at place (document does not specify in person or not, or one-way or not)',
    'Contact.ThreatenCoerce.Unspecified':'Communicator communicated with recipient about topic at place (document does not specify in person or not, or one-way or not)',
    'Control.ImpedeInterfereWith.Unspecified':'Impeder impeded or interfered with impeded event at place',
    'Disaster.Crash.Unspecified':'Drive or Passenger in vehicle crashed into crash object at place',
    'Disaster.DiseaseOutbreak.Unspecified':'Disease broke out among victims or population at place',
    'Disaster.FireExplosion.Unspecified':'Fire explosion object caught fire or exploded from instrument at place',
    'GenericCrime.GenericCrime.GenericCrime':'Perpetrator committed a crime against victim at place',
    'Justice.Acquit.Unspecified':'Court or judge acquitted defendant of crime in place',
    'Justice.ArrestJailDetain.Unspecified':'Jailer arrested or jailed detainee for crime at place',
    'Justice.ChargeIndict.Unspecified':'Prosecutor charged or indicted defendant before judge or court for crime in place',
    'Justice.Convict.Unspecified':'Judge or court convicted defendant of crime in place',
    'Justice.InvestigateCrime.Unspecified':'Investigator investigated defendant for crime in place',
    'Justice.ReleaseParole.Unspecified':'Judge or court released or paroled defendant from crime in place',
    'Justice.Sentence.Unspecified':'Judge or court sentenced defendant for crime to sentence in place',
    'Justice.TrialHearing.Unspecified':'Prosecutor tried defendant before judge or court for crime in place',
    'Life.Consume.Unspecified':'Consuming entity consumed thing at place',
    'Life.Die.Unspecified':'Victim died at place from medical issue, killed by killer',
    'Life.Illness.Unspecified':'Victim has disease at place, deliberately infected by deliberate injurer',
    'Life.Infect.Unspecified':'Victim was infected with infecting agent from source at place',
    'Life.Injure.Unspecified':'Victim was injured by injurer using instrument in body part with medical condition at place',
    'Medical.Diagnosis.Unspecified':'Treater diagnosed patient with symptom sign for medical condition at place',
    'Medical.Intervention.Unspecified':'Treater treated patient for medical issue with instrument means at place',
    'Medical.Vaccinate.Unspecified':'Treater vaccinated patient via vaccine target for vaccine target at place',
    'Movement.Transportation.Evacuation':'Transporter transported passenger artifact in vehicle from origin place to destination place',
    'Movement.Transportation.IllegalTransportation':'Transporter illegally transported passenger artifact in vehicle from origin place to destination place',
    'Movement.Transportation.PreventPassage':'Preventer prevents transporter from entering destination place from origin place to transport passenger artifact using vehicle',
    'Movement.Transportation.Unspecified':'Transporter transported passenger artifact in vehicle from origin place to destination place',
    'Personnel.EndPosition.Unspecified':'Employee stopped working in position at organization(placeOfEmployment) in place',
    'Personnel.StartPosition.Unspecified':'Employee started working in position at organization(placeOfEmployment) in place',
    'Transaction.Donation.Unspecified':'Giver gave artifact money to recipient for the benefit of beneficiary at place',
    'Transaction.ExchangeBuySell.Unspecified':'Giver bought, sold, or traded acquired entity to recipient in exchange for payment barter for the benefit of beneficiary at place',
}
TEMPLATE_ACE_Role = {
    "Business.Declare-Bankruptcy": {
        "Org": 'Failing or bankrupt companies/organizations.',
    },
    "Business.End-Org": {
        "Org": 'Dissolved or dissolving companies/organizations.',
        "Place": 'The location of a dissolved or dissolving companies/organizations.'
    },
    "Business.Merge-Org": {
        "Org": 'Companies or organizations involved in a merger.',
    },
    "Business.Start-Org": {
        "Agent": 'The individuals or entities that founded the company or organization.',
        "Org": 'The company or organization that has been created.',
        "Place": 'The location of the created company or organization.'
    },
    "Conflict.Attack": {
        "Attacker": 'The organization or individuals initiating the attack.',
        "Target": 'The target of the attack.',
        "Instrument": 'The instruments used by the attacker.',
        "Place": 'The location where the attack occurred.',
    },
    "Conflict.Demonstrate": {
        "Entity": 'The entities participating in the parade.',
        "Place": 'The location where the parade occurred.'
    },
    "Contact.Meet": {
        "Entity": 'Multiple entities participating in the meeting.',
        "Place": 'The location where the meeting took place.'
    },
    "Contact.Phone-Write": {
        "Entity": 'Entities participating in remote communication such as phone or email.',
        "Place": 'The location of the entities.'
    },
    "Justice.Acquit": {
        "Defendant": 'The individuals or organizations acquitted for release.',
        "Adjudicator": 'Adjudicator for determining acquittal.'
    },
    "Justice.Appeal": {
        "Plaintiff": 'The plaintiff appealing the decision.',
        "Place": 'The location where the plaintiff is appealing.',
        "Adjudicator": 'The adjudicators ruling on the appeal.'
    },
    "Justice.Arrest-Jail": {
        "Person": 'The individuals or organizations that have been arrested.',
        "Agent": 'The individuals or organizations conducting the arrest.',
        "Place": 'The location where the arrest took place.'
    },
    "Justice.Charge-Indict": {
        "Defendant": 'The individuals or organizations that have been charged',
        "Prosecutor": 'The entity or individual bringing the charges.',
        "Place": 'The place where charges are made.',
        "Adjudicator": 'Adjudicators conducting charge trials.'
    },
    "Justice.Convict": {
        "Defendant": 'The individuals or organizations considered to be criminals.',
        "Place": 'The place where the conviction was made.',
        "Adjudicator": 'Adjudicators determining the conviction.',
    },
    "Justice.Execute": {
        "Person": 'The person who have been executed.',
        "Agent": 'The individuals or organizations carrying out the execution.',
        "Place": 'The place where the execution took place.',
    },
    "Justice.Extradite": {
        "Destination": 'The destination for extradition.',
        "Origin": 'The point of origin for extradition.',
        "Agent": 'The individuals or organizations conducting the extradition.'
    },
    "Justice.Fine": {
        "Entity": 'The individuals or organizations fined.',
        "Place": 'The location where the fine is imposed.',
        "Adjudicator": 'Adjudicators determining the fine.'
    },
    "Justice.Pardon": {
        "Defendant": 'Individuals or organizations who have been pardoned.',
        "Adjudicator": 'The individuals or organizations granting pardons.',
        "Place": 'The entity or jurisdiction granting pardons.'
    },
    "Justice.Release-Parole": {
        "Person": 'Person released or paroled.',
        "Entity": 'Individual or organization requesting release or parole.',
        "Place": 'Location where release or parole takes place.'
    },
    "Justice.Sentence": {
        "Defendant": 'Individual or organization sentenced.',
        "Place": 'Location where sentencing occurs.',
        "Adjudicator": 'Individual or organization adjudicating the sentence.'
    },
    "Justice.Sue": {
        "Defendant": 'Individual or organization being sued.',
        "Plaintiff": 'Individual or organization initiating the suit.',
        "Place": 'Location where the lawsuit is filed.',
        "Adjudicator": 'Adjudicator adjudicating the suit.'
    },
    "Justice.Trial-Hearing": {
        "Defendant": 'Individual or organization being interrogated or tried.',
        "Prosecutor": 'Prosecutor.',
        "Place": 'Location of the interrogation or trial.',
        "Adjudicator": 'Individual or organization conducting the trial or hearing.'
    },
    "Life.Be-Born": {
        "Person": 'Person being born.',
        "Place": 'Place of birth.'
    },
    "Life.Die": {
        "Agent": "Individual or organization causing the victim's death.",
        "Victim": 'Deceased victim.',
        "Instrument": 'Instrument causing death.',
        "Place": 'Location where the death occurred.'
    },
    "Life.Divorce": {
        "Person": 'Individual involved in the divorce.',
        "Place": 'Location where the divorce occurred.'
    },
    "Life.Injure": {
        "Agent": 'Individual or organization causing injury to the victim.',
        "Victim": 'Injured victim.',
        "Instrument": 'Instrument causing injury.',
        "Place": 'Location where the injury occurred.'
    },
    "Life.Marry": {
        "Person": 'Individual getting married.',
        "Place": 'Location of the marriage.'
    },
    "Movement.Transport": {
        "Artifact": "Individual or organization being transported.",
        "Destination": "Final destination of the transport.",
        "Origin": "Starting point of the transport.",
        "Vehicle": "Vehicle used for the transport.",
        "Agent": "Individual or organization facilitating the transport."
    },
    "Personnel.Elect": {
        "Person": "Individual or organization elected.",
        "Entity": "Organization or position appointed through election.",
        "Place": "Location where the election occurs."
    },
    "Personnel.End-Position": {
        "Person": "Individual leaving the position.",
        "Entity": "Company or organization where the departure occurs.",
        "Place": "Location where the departure occurs."
    },
    "Personnel.Nominate": {
        "Person": "Individual or organization involved in the nomination.",
        "Agent": "Individual or organization prompting the nomination."
    },
    "Personnel.Start-Position": {
        "Person": "Individual taking up the position.",
        "Entity": "Company or organization where the position is taken.",
        "Place": "Location where the position is taken."
    },
    "Transaction.Transfer-Money": {
        "Giver": "Individual or organization giving the funds.",
        "Recipient": "Individual or organization receiving the funds.",
        "Place": "Location where the funds are used.",
        "Beneficiary": "Individual or organization benefiting from the funds."
    },
    "Transaction.Transfer-Ownership": {
        "Buyer": "Buyer of the transferred ownership.",
        "Artifact": "Asset being transferred.",
        "Seller": "Seller transferring the ownership.",
        "Place": "Location where the asset transfer occurs.",
        "Beneficiary": "Beneficiary of the asset transfer."
    }
}


TEMPLATE_ACE_Event = {
    "Business.Declare-Bankruptcy": {
        "event subtype": "declare bankruptcy",
        "event type": "Business:Declare-Bankruptcy",
        "keywords": ['bankruptcy', 'bankrupt', 'Bankruptcy'],
        "event description": "The event is related to some organization declaring bankruptcy.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Org} declared bankruptcy.",
        "valid roles": ["Org"],
    },
    "Business.End-Org": {
        "event subtype": "end organization",
        "event type": "Business:End-Org",
        "keywords": ['dissolve', 'disbanded', 'close'],
        "event description": "The event is related to some organization ceasing to exist.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Org} dissolved.",
        "valid roles": ["Org", "Place"],
    },
    "Business.Merge-Org": {
        "event subtype": "merge organization",
        "event type": "Business:Merge-Org",
        "keywords": ['merge', 'merging', 'merger'],
        "event description": "The event is related to two or more organization coming together to form a new organization.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Org} was merged.",
        "valid roles": ["Org"],
    },
    "Business.Start-Org": {
        "event subtype": "start organization",
        "event type": "Business:Start-Org",
        "keywords": ['founded', 'create', 'launch'],
        "event description": "The event is related to a new organization being created.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Agent} launched {ROLE_Org} in {ROLE_Place}.",
        "valid roles": ["Agent", "Org", "Place"],
    },
    "Conflict.Attack": {
        "event subtype": "attack",
        "event type": "Conflict:Attack",
        "keywords": ['war', 'attack', 'terrorism'],
        "event description": "The event is related to conflict and some violent physical act.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Attacker} attacked {ROLE_Target} by {ROLE_Instrument} in {ROLE_Place}.",
        "valid roles": ["Attacker", "Target", "Instrument", "Place"],
    },
    "Conflict.Demonstrate": {
        "event subtype": "demonstrate",
        "event type": "Conflict:Demonstrate",
        "keywords": ['rally', 'protest', 'demonstrate'],
        "event description": "The event is related to a large number of people coming together to protest.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Entity} protested at {ROLE_Place}.",
        "valid roles": ["Entity", "Place"],
    },
    "Contact.Meet": {
        "event subtype": "meet",
        "event type": "Contact:Meet",
        "keywords": ['meeting', 'met', 'summit'],
        "event description": "The event is related to a group of people meeting and interacting with one another face-to-face.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Entity} met at {ROLE_Place}.",
        "valid roles": ["Entity", "Place"],
    },
    "Contact.Phone-Write": {
        "event subtype": "phone write",
        "event type": "Contact:Phone-Write",
        "keywords": ['call', 'communicate', 'e-mail'],
        "event description": "The event is related to people phone calling or messaging one another.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Entity} called or texted messages at {ROLE_Place}.",
        "valid roles": ["Entity", "Place"],
    },
    "Justice.Acquit": {
        "event subtype": "acquit",
        "event type": "Justice:Acquit",
        "keywords": ['acquitted', 'acquittal', 'acquit'],
        "event description": "The event is related to someone being acquitted.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} was acquitted of the charges by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Adjudicator"],
    },
    "Justice.Appeal": {
        "event subtype": "appeal",
        "event type": "Justice:Appeal",
        "keywords": ['appeal', 'appealing', 'appeals'],
        "event description": "The event is related to someone appealing the decision of a court.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Plaintiff} in {ROLE_Place} appealed the adjudication from {ROLE_Adjudicator}.",
        "valid roles": ["Plaintiff", "Place", "Adjudicator"],
    },
    "Justice.Arrest-Jail": {
        "event subtype": "arrest jail",
        "event type": "Justice:Arrest-Jail",
        "keywords": ['arrest', 'jail', 'detained'],
        "event description": "The event is related to a person getting arrested or a person being sent to jail.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was sent to jailed or arrested by {ROLE_Agent} in {ROLE_Place}.",
        "valid roles": ["Person", "Agent", "Place"],
    },
    "Justice.Charge-Indict": {
        "event subtype": "charge indict",
        "event type": "Justice:Charge-Indict",
        "keywords": ['indict', 'charged', 'accused'],
        "event description": "The event is related to someone or some organization being accused of a crime.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} was charged by {ROLE_Prosecutor} in {ROLE_Place}, and the adjudication was judged by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Prosecutor", "Place", "Adjudicator"],
    },
    "Justice.Convict": {
        "event subtype": "convict",
        "event type": "Justice:Convict",
        "keywords": ['convicted', 'guilty', 'verdict'],
        "event description": "The event is related to someone being found guilty of a crime.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} was convicted of a crime in {ROLE_Place}, and the adjudication was judged by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Place", "Adjudicator"],
    },
    "Justice.Execute": {
        "event subtype": "execute",
        "event type": "Justice:Execute",
        "keywords": ['execution', 'executed', 'execute'],
        "event description": "The event is related to someone being executed to death.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was executed by {ROLE_Agent} at {ROLE_Place}.",
        "valid roles": ["Person", "Agent", "Place"],
    },
    "Justice.Extradite": {
        "event subtype": "extradite",
        "event type": "Justice:Extradite",
        "keywords": ['extradition', 'extradited', 'extraditing'],
        "event description": "The event is related to justice. The event occurs when a person was extradited from one place to another place.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was extradicted to {ROLE_Destination} from {ROLE_Origin}, and {ROLE_Agent} was responsible for the extradition.",
        "valid roles": ["Destination", "Origin", "Agent"],
    },
    "Justice.Fine": {
        "event subtype": "fine",
        "event type": "Justice:Fine",
        "keywords": ['fine', 'fined', 'payouts'],
        "event description": "The event is related to someone being issued a financial punishment.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Entity} in {ROLE_Place} was ordered by {ROLE_Adjudicator} to pay a fine.",
        "valid roles": ["Entity", "Place", "Adjudicator"],
    },
    "Justice.Pardon": {
        "event subtype": "pardon",
        "event type": "Justice:Pardon",
        "keywords": ['pardon', 'pardoned', 'remission'],
        "event description": "The event is related to someone being pardoned.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} received a pardon from {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Adjudicator", 'Place'],
    },
    "Justice.Release-Parole": {
        "event subtype": "release parole",
        "event type": "Justice:Release-Parole",
        "keywords": ['parole', 'release', 'free'],
        "event description": "The event is related to an end to someone's custody in prison.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was released by {ROLE_Entity} from {ROLE_Place}.",
        "valid roles": ["Person", "Entity", "Place"],
    },
    "Justice.Sentence": {
        "event subtype": "sentence",
        "event type": "Justice:Sentence",
        "keywords": ['sentenced', 'sentencing', 'sentence'],
        "event description": "The event is related to someone being sentenced to punishment because of a crime.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} was sentenced to punishment in {ROLE_Place}, and the adjudication was judged by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Place", "Adjudicator"],
    },
    "Justice.Sue": {
        "event subtype": "sue",
        "event type": "Justice:Sue",
        "keywords": ['sue', 'lawsuit', 'suit'],
        "event description": "The event is related to a court proceeding that has been initiated and someone sue the other.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant} was sued by {ROLE_Plaintiff} in {ROLE_Place}, and the adjudication was judged by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Plaintiff", "Place", "Adjudicator"],
    },
    "Justice.Trial-Hearing": {
        "event subtype": "trial hearing",
        "event type": "Justice:Trial-Hearing",
        "keywords": ['trial', 'hearing', 'proceeding'],
        "event description": "The event is related to a trial or hearing for someone.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Defendant}, prosecuted by {ROLE_Prosecutor}, faced a trial in {ROLE_Place}, and the hearing was judged by {ROLE_Adjudicator}.",
        "valid roles": ["Defendant", "Prosecutor", "Place", "Adjudicator"],
    },
    "Life.Be-Born": {
        "event subtype": "born",
        "event type": "Life:Be-Born",
        "keywords": ['born', 'birth', 'bore'],
        "event description": "The event is related to life and someone is given birth to.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was born in {ROLE_Place}.",
        "valid roles": ["Person", "Place"],
    },
    "Life.Die": {
        "event subtype": "die",
        "event type": "Life:Die",
        "keywords": ['kill', 'death', 'assassination'],
        "event description": "The event is related to life and someone died.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Agent} led to {ROLE_Victim} died by {ROLE_Instrument} in {ROLE_Place}.",
        "valid roles": ["Agent", "Victim", "Instrument", "Place"],
    },
    "Life.Divorce": {
        "event subtype": "divorce",
        "event type": "Life:Divorce",
        "keywords": ['divorce', 'divorced', 'Divorce'],
        "event description": "The event is related to life and someone was divorced.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} divorced in {ROLE_Place}.",
        "valid roles": ["Person", "Place"],
    },
    "Life.Injure": {
        "event subtype": "injure",
        "event type": "Life:Injure",
        "keywords": ['injure', 'wounded', 'hurt'],
        "event description": "The event is related to life and someone is injured.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Agent} led to {ROLE_Victim} injured by {ROLE_Instrument} in {ROLE_Place}.",
        "valid roles": ["Agent", "Victim", "Instrument", "Place"],
    },
    "Life.Marry": {
        "event subtype": "marry",
        "event type": "Life:Marry",
        "keywords": ['marry', 'marriage', 'married'],
        "event description": "The event is related to life and someone is married.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} got married in {ROLE_Place}.",
        "valid roles": ["Person", "Place"],
    },
    "Movement.Transport": {
        "event subtype": "transport",
        "event type": "Movement:Transport",
        "keywords": ['travel', 'go', 'move'],
        "event description": "The event is related to movement. The event occurs when a weapon or vehicle is moved from one place to another.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Artifact} was sent to {ROLE_Destination} from {ROLE_Origin} by {ROLE_Vehicle}, and {ROLE_Agent} was responsible for the transport.",
        "valid roles": ["Artifact", "Destination", "Origin", "Vehicle", "Agent"],
    },
    "Personnel.Elect": {
        "event subtype": "elect",
        "event type": "Personnel:Elect",
        "keywords": ['election', 'elect', 'elected'],
        "event description": "The event is related to a candidate wins an election.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was elected a position, and the election was voted by {ROLE_Entity} in {ROLE_Place}.",
        "valid roles": ["Person", "Entity", "Place"],
    },
    "Personnel.End-Position": {
        "event subtype": "end position",
        "event type": "Personnel:End-Position",
        "keywords": ['former', 'laid off', 'fired'],
        "event description": "The event is related to a person stops working for an organization or a hiring manager.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} stopped working for {ROLE_Entity} at {ROLE_Place}.",
        "valid roles": ["Person", "Entity", "Place"],
    },
    "Personnel.Nominate": {
        "event subtype": "nominate",
        "event type": "Personnel:Nominate",
        "keywords": ['named', 'nomination', 'nominate'],
        "event description": "The event is related to a person being nominated for a position.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} was nominated by {ROLE_Entity} to do a job.",
        "valid roles": ["Person", "Agent"],
    },
    "Personnel.Start-Position": {
        "event subtype": "start position",
        "event type": "Personnel:Start-Position",
        "keywords": ['hire', 'appoint', 'join'],
        "event description": "The event is related to a person begins working for an organization or a hiring manager.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Person} got new job and was hired by {ROLE_Entity} in {ROLE_Place}.",
        "valid roles": ["Person", "Entity", "Place"],
    },
    "Transaction.Transfer-Money": {
        "event subtype": "transfer money",
        "event type": "Transaction:Transfer-Money",
        "keywords": ['pay', 'donation', 'loan'],
        "event description": "The event is related to transaction. The event occurs when someone is giving, receiving, borrowing, or lending money.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Giver} paid {ROLE_Recipient} in {ROLE_Place}.",
        "valid roles": ["Giver", "Recipient", "Place", "Beneficiary"],
    },
    "Transaction.Transfer-Ownership": {
        "event subtype": "transfer ownership",
        "event type": "Transaction:Transfer-Ownership",
        "keywords": ['sell', 'buy', 'acquire'],
        "event description": "The event is related to transaction. The event occurs when an item or an organization is sold or gave to some other.",
        "ED template": "Event trigger is {Trigger}.",
        "EAE template": "{ROLE_Buyer} got {ROLE_Artifact} from {ROLE_Place} in {ROLE_Place}.",
        "valid roles": ["Buyer", "Artifact", "Seller", "Place", "Beneficiary"],
    },
}

TEMPLATE_FEWNERD = {
    "None": "{ent} do/does not belong to any known entities.",
    "person-artist/author": "{ent} is an artist or author.",
    "person-actor": "{ent} is an actor.",
    "art-writtenart": "{ent} is a kind of writtenart.",
    "person-director": "{ent} is a director.",
    "person-other": "{ent} is a person, but not affiliated with following professions: actor, artist, athlete, author, director, politician, scholar, soldier.",
    "organization-other": "{ent} pertains to an organization that does not fall under the categories of company, educational institution, government, media, political party, religion, sports league, sports team, band or musical group.",
    "organization-company": "{ent} is a company",
    "organization-sportsteam": "{ent} is a sports team",
    "organization-sportsleague": "{ent} is a sports league",
    "product-car": "{ent} is a kind of car",
    "event-protest": "{ent} refers to a protest, uprising or revolution event",
    "organization-government/governmentagency": "{ent} refers to a government or governmental agency",
    "other-biologything": "{ent} is a special term about biology / life science.",
    "location-GPE": "{ent} is a kind of geopolitical entity",
    "location-other": "{ent} is a geographic locaton that does not fall under the categories of geopolitical entity, body of water, island, mountain, park, road, railway and transit.",
    "person-athlete": "{ent} is an athlete or coach.",
    "art-broadcastprogram": "{ent} is a broadcast program.",
    "product-other": "{ent} is a kind of product that does not fall under the categories of airplane, train, ship, car, weapon, food, electronic game and software.",
    "building-other": "{ent} is a kind of building that does not fall under the categories of airport, hospital, hotel, library, restaurant, sports facility and theater",
    "product-weapon": "{ent} is a kind of weapon.",
    "building-airport": "{ent} is an airport.",
    "building-sportsfacility": "{ent} is a sports facility building.",
    "person-scholar": "{ent} is a scholar.",
    "art-music": "{ent} is a music.",
    "event-other": "{ent} refers to some event except attack, election, natural disaster, protest, revolution and sports",
    "other-language": "{ent} is a kind of human language.",
    "other-chemicalthing": "{ent} is some special term about chemical science.",
    "art-film": "{ent} is a film.",
    "building-hospital": "{ent} is a hospital.",
    "other-law": "{ent} is a legal document, a term or a convention in legal sense.",
    "product-airplane": "{ent} is kind of airplane product.",
    "location-road/railway/highway/transit": "{ent} is a geographic position about roadways, railways, highways or public transit systems.",
    "person-soldier": "{ent} is a soldier",
    "location-mountain": "{ent} is geographic position about mountain.",
    "organization-education": "{ent} is an educational institute/organization.",
    "organization-media/newspaper": "{ent} is a media/newspaper organization.",
    "product-software": "{ent} is a software product.",
    "location-island": "{ent} is geographic position about island.",
    "location-bodiesofwater": "{ent} is geographic position situated near a body of water.",
    "building-library": "{ent} is a library.",
    "other-astronomything": "{ent} is a special term about astronomy.",
    "person-politician": "{ent} is a politician or lawyer or judge.",
    "building-hotel": "{ent} is a hotel building.",
    "product-game": "{ent} is a electronic game product.",
    "other-award": "{ent} is a kind of award.",
    "event-sportsevent": "{ent} refers to some event related to sports.",
    "organization-showorganization": "{ent} is a band or musical organization.",
    "other-educationaldegree": "{ent} is a kind of educational degree.",
    "building-theater": "{ent} is a theater.",
    "other-disease": "{ent} is a kind of disease.",
    "event-election": "{ent} is an event about election.",
    "organization-politicalparty": "{ent} is a political party/organization.",
    "other-currency": "{ent} is a kind of currency.",
    "event-attack/battle/war/militaryconflict": "{ent} is an event about attack, battle, war or military conflict.",
    "product-ship": "{ent} is a ship.",
    "building-restaurant": "{ent} is a restaurant.",
    "other-livingthing": "{ent} is a living animal/creature/organism.",
    "art-other": "{ent} is a work of art, but not belong to the categories of music, film, written art, broadcast or painting.",
    "event-disaster": "{ent} is a natural disaster event.",
    "organization-religion": "{ent} is a religious organization.",
    "other-medical": "{ent} refers to some kind of medicine.entity",
    "location-park": "{ent} is a park.",
    "other-god": "{ent} is a god in some legend/religious story.",
    "product-food": "{ent} is a kind of food.",
    "product-train": "{ent} is a kind of train(vehicle).",
    "art-painting": "{ent} is an art painting.",
}


TEMPLATE_ACE = {
    "None": "The word {evt} does not trigger any known event.",
    "Movement.Transport": "The word {evt} triggers a TRANSPORT event: an ARTIFACT (WEAPON or VEHICLE) or a PERSON is moved from one PLACE (GEOPOLITICAL ENTITY, FACILITY, LOCATION) to another.",
    "Personnel.Elect": "The word {evt} triggers an ELECT event which implies an election.",
    "Personnel.Start-Position": "The word {evt} triggers a START-POSITION event: a PERSON elected or appointed begins working for (or changes offices within) an ORGANIZATION or GOVERNMENT.",
    "Personnel.Nominate": "The word {evt} triggers a NOMINATE event: a PERSON is proposed for a position through official channels.",
    "Conflict.Attack": "The word {evt} triggers an ATTACK event: a violent physical act causing harm or damage.",
    "Personnel.End-Position": "The word {evt} triggers an END-POSITION event: a PERSON stops working for (or changes offices within) an ORGANIZATION or GOVERNMENT.",
    "Contact.Meet": "The word {evt} triggers a MEET event: two or more entities come together at a single location and interact with one another face-to-face.",
    "Life.Marry": "The word {evt} triggers a MARRY event: two people are married under the legal definition.",
    "Contact.Phone-Write": "The word {evt} triggers a PHONE-WRITE event: two or more people directly engage in discussion which does not take place 'face-to-face'.",
    "Transaction.Transfer-Money": "The word {evt} triggers a TRANSFER-MONEY event: giving, receiving, borrowing, or lending money when it is NOT in the context of purchasing something. ",
    "Justice.Sue": "The word {evt} triggers a SUE event: a court proceeding has been initiated for the purposes of determining the liability of a PERSON, ORGANIZATION or GEOPOLITICAL ENTITY accused of committing a crime or neglecting a commitment",
    "Conflict.Demonstrate": "The word {evt} triggers a DEMONSTRATE event: a large number of people come together in a public area to protest or demand some sort of official action. For eample: protests, sit-ins, strikes and riots.",
    "Business.End-Org": "The word {evt} triggers an END-ORG event: an ORGANIZATION ceases to exist (in other words, goes out of business).",
    "Life.Injure": "The word {evt} triggers an INJURE event: a PERSON gets/got injured whether it occurs accidentally, intentionally or even self-inflicted.",
    "Life.Die": "The word {evt} triggers a DIE event: a PERSON dies/died whether it occurs accidentally, intentionally or even self-inflicted.",
    "Justice.Arrest-Jail":  "The word {evt} triggers a DIE event: a PERSON is sent to prison.",
    "Transaction.Transfer-Ownership": "The word {evt} triggers a TRANSFER-OWNERSHIP event: The buying, selling, loaning, borrowing, giving, or receiving of artifacts or organizations by an individual or organization.",
    "Justice.Execute": "The word {evt} triggers an EXECUTE event: a PERSON is/was executed",
    "Justice.Trial-Hearing": "The word {evt} triggers a TRIAL-HEARING event: a court proceeding has been initiated for the purposes of determining the guilt or innocence of a PERSON, ORGANIZATION or GEOPOLITICAL ENTITY accused of committing a crime.",
    "Justice.Sentence": "The word {evt} triggers a SENTENCE event:  the punishment for the DEFENDANT is issued",
    "Life.Be-Born": "The word {evt} triggers a BE-BORN event: a PERSON is given birth to.",
    "Justice.Charge-Indict": "The word {evt} triggers a CHARGE-INDICT event: a PERSON, ORGANIZATION or GEOPOLITICAL ENTITY is accused of a crime",
    "Business.Start-Org": "The word {evt} triggers a START-ORG event: a new ORGANIZATION is created.",
    "Justice.Convict": "The word {evt} trigges a CONVICT event: a PERSON, ORGANIZATION or GEOPOLITICAL ENTITY is convicted whenever it has been found guilty of a CRIME.",
    "Business.Declare-Bankruptcy": "The word {evt} triggers a DECLARE-BANKRUPTCY event: an Entity officially requests legal protection from debt collection due to an extremely negative balance sheet.",
    "Justice.Release-Parole": "The word {evt} triggers a RELEASE-PAROLE event.",
    "Justice.Fine": "The word {evt} triggers a FINE event: a GEOPOLITICAL ENTITY, PERSON or ORGANIZATION get financial punishment typically as a result of court proceedings.",
    "Justice.Pardon": "The word {evt} triggers a PARDON event:  a head-of-state or their appointed representative lifts a sentence imposed by the judiciary.",
    "Justice.Appeal": "The word {evt} triggers a APPEAL event: the decision of a court is taken to a higher court for review",
    "Business.Merge-Org": "The word {evt} triggers a MERGE-ORG event: two or more ORGANIZATION Entities come together to form a new ORGANIZATION Entity. ",
    "Justice.Extradite": "The word {evt} triggers a EXTRADITE event.",
    "Life.Divorce": "The word {evt} triggers a DIVORCE event: two people are officially divorced under the legal definition of divorce.",
    "Justice.Acquit": "The word {evt} triggers a ACQUIT event: a trial ends but fails to produce a conviction.",   
}


TEMPLATE_TACREV = {
    "None": "{subj} has no known relations to {obj}",
    "per:stateorprovince_of_death": "{subj} died in the state or province {obj}",
    "per:title": "{subj} is a {obj}",
    "org:member_of": "{subj} is the member of {obj}",
    "per:other_family": "{subj} is the other family member of {obj}",
    "org:country_of_headquarters": "{subj} has a headquarter in the country {obj}",
    "org:parents": "{subj} has the parent company {obj}",
    "per:stateorprovince_of_birth": "{subj} was born in the state or province {obj}",
    "per:spouse": "{subj} is the spouse of {obj}",
    "per:origin": "{subj} has the nationality {obj}",
    "per:date_of_birth": "{subj} has birthday on {obj}",
    "per:schools_attended": "{subj} studied in {obj}",
    "org:members": "{subj} has the member {obj}",
    "org:founded": "{subj} was founded in {obj}",
    "per:stateorprovinces_of_residence": "{subj} lives in the state or province {obj}",
    "per:date_of_death": "{subj} died in the date {obj}",
    "org:shareholders": "{subj} has shares hold in {obj}",
    "org:website": "{subj} has the website {obj}",
    "org:subsidiaries": "{subj} owns {obj}",
    "per:charges": "{subj} is convicted of {obj}",
    "org:dissolved": "{subj} dissolved in {obj}",
    "org:stateorprovince_of_headquarters": "{subj} has a headquarter in the state or province {obj}",
    "per:country_of_birth": "{subj} was born in the country {obj}",
    "per:siblings": "{subj} is the siblings of {obj}",
    "org:top_members/employees": "{subj} has the high level member {obj}",
    "per:cause_of_death": "{subj} died because of {obj}",
    "per:alternate_names": "{subj} has the alternate name {obj}",
    "org:number_of_employees/members": "{subj} has the number of employees {obj}",
    "per:cities_of_residence": "{subj} lives in the city {obj}",
    "org:city_of_headquarters": "{subj} has a headquarter in the city {obj}",
    "per:children": "{subj} is the parent of {obj}",
    "per:employee_of": "{subj} is the employee of {obj}",
    "org:political/religious_affiliation": "{subj} has political affiliation with {obj}",
    "per:parents": "{subj} has the parent {obj}",
    "per:city_of_birth": "{subj} was born in the city {obj}",
    "per:age": "{subj} has the age {obj}",
    "per:countries_of_residence": "{subj} lives in the country {obj}",
    "org:alternate_names": "{subj} is also known as {obj}",
    "per:religion": "{subj} has the religion {obj}",
    "per:city_of_death": "{subj} died in the city {obj}",
    "per:country_of_death": "{subj} died in the country {obj}",
    "org:founded_by": "{subj} was founded by {obj}"
}